#include <algorithm>
#include <cstdint>
#include <iostream>
#include <vector>

using namespace std;


struct BeforeAfter {
    int before = -1;
    int after = -1;
};

struct Coordinate {
    int x;
    int y;
    int index;

    bool operator< (const Coordinate &other) const {
        return x < other.x;
    }
};

void generateClosestVector(const vector<Coordinate>& coordinates, vector<BeforeAfter>& closestLarger) {
    int n = coordinates.size();

    for (int i = 1; i < n; i++) {
        if (coordinates[i].y <= coordinates[i - 1].y) {
            closestLarger[i].before = i-1;
        }

        else {
            int candidateIndex = closestLarger[i - 1].before;

            while (candidateIndex != -1) {
                if (coordinates[i].y <= coordinates[candidateIndex].y) {
                    closestLarger[i].before = candidateIndex;

                    break;
                }

                candidateIndex = closestLarger[candidateIndex].before;
            }
        }
    }

    for (int i = n - 2; i >= 0; i--) {
        if (coordinates[i].y <= coordinates[i + 1].y) {
            closestLarger[i].after = i+1;
        }

        else {
            int candidateIndex = closestLarger[i + 1].after;

            while (candidateIndex != -1) {
                if (coordinates[i].y <= coordinates[candidateIndex].y) {
                    closestLarger[i].after = candidateIndex;

                    break;
                }

                candidateIndex = closestLarger[candidateIndex].after;
            }
        }
    }
}

int main() {
    int n;

    cin >> n;

    vector<Coordinate> coordinates(n);

    for (int i = 0; i < n; i++) {
        cin >> coordinates[i].x;
    }

    for (int i = 0; i < n; i++) {
        cin >> coordinates[i].y;
        coordinates[i].index = i;
    }

    sort(coordinates.begin(), coordinates.end());

    vector<int> reverseMap(n);
    for (int i = 0; i < n; i++) {
        reverseMap[coordinates[i].index] = i;
    }

    vector<BeforeAfter> closestLarger(n);
    //generateClosestVector(coordinates, closestLarger);

    for (const int i: reverseMap) {
        if (closestLarger[i].before == -1 && closestLarger[i].after == -1) cout << -1 << endl;

        else if (closestLarger[i].before == -1) {
            int indexAfter = closestLarger[i].after;

            int distanceAfter = coordinates[indexAfter].x - coordinates[indexAfter].y + coordinates[i].y - coordinates[i].x;

            cout << distanceAfter << endl;
        }

        else if (closestLarger[i].after == -1) {
            int indexBefore = closestLarger[i].before;

            int distanceBefore = coordinates[i].x - coordinates[indexBefore].x - coordinates[indexBefore].y + coordinates[i].y;

            cout << distanceBefore << endl;
        }

        else {
            int indexAfter = closestLarger[i].after;
            int distanceAfter = coordinates[indexAfter].x - coordinates[indexAfter].y + coordinates[i].y - coordinates[i].x;

            int indexBefore = closestLarger[i].before;
            int distanceBefore = coordinates[i].x - coordinates[indexBefore].x - coordinates[indexBefore].y + coordinates[i].y;

            cout << min(distanceBefore, distanceAfter) << endl;
        }
    }

    return 0;
}